----------------------------------------
--                                    --
--  x  x x   x x   x xxxxxxx          --
--  x  x xx xx xx xx  x x x   events  --
--  xxxx x x x x x x  x x x  library  --
--  x  x x   x x   x  x x x   v.0.90.0--
--  x  x x   x x   x xxxxxxx          --
--                                    --
----------------------------------------
--
-- purpose:    homm3 events emulation library
-- created by: Ungerade, 12.2007 - 02.2008
-- version:    0.90.0-beta
--
----------------------------------------


------------------------------
--       HMM3 Globals
------------------------------

hmm3GlobalEventParams = {};          --    

hmm3Regions = {};                    --    region events

hmm3Timers = {};                     --    timer events

hmm3TimerHandlerUp = nil;            --     NEW_DAY_TRIGGER

hmm3TreasureEventCurrents = {};      --     treasure event

------------------------------
--         HMM3 Helpers 
------------------------------

---------------------------------------------------
--    item   table
--
-- param table - 
-- param item  - 
-- return      -  ,     
--           nil   
---------------------------------------------------
function hmm3IsItemInTable ( table, item )
	for key, value in table do
		if value == item then
			return key;
		end;
	end;

	return nil;		
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Heaven
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateHeavenMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_PEASANT,  count = counts[1] },
		{ monster = CREATURE_ARCHER,   count = counts[2] },
		{ monster = CREATURE_FOOTMAN,  count = counts[3] },
		{ monster = CREATURE_GRIFFIN,  count = counts[4] },
		{ monster = CREATURE_PRIEST,   count = counts[5] },
		{ monster = CREATURE_CAVALIER, count = counts[6] },
		{ monster = CREATURE_ANGEL,    count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Inferno
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateInfernoMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_FAMILIAR,   count = counts[1] },
		{ monster = CREATURE_DEMON,      count = counts[2] },
		{ monster = CREATURE_HELL_HOUND, count = counts[3] },
		{ monster = CREATURE_SUCCUBUS,   count = counts[4] },
		{ monster = CREATURE_NIGHTMARE,  count = counts[5] },
		{ monster = CREATURE_PIT_FIEND,  count = counts[6] },
		{ monster = CREATURE_DEVIL,      count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Necropolis
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateNecropolisMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_SKELETON,     count = counts[1] },
		{ monster = CREATURE_WALKING_DEAD, count = counts[2] },
		{ monster = CREATURE_MANES,        count = counts[3] },
		{ monster = CREATURE_VAMPIRE,      count = counts[4] },
		{ monster = CREATURE_LICH,         count = counts[5] },
		{ monster = CREATURE_WIGHT,        count = counts[6] },
		{ monster = CREATURE_BONE_DRAGON,  count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Preserve
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreatePreserveMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_PIXIE,         count = counts[1] },
		{ monster = CREATURE_BLADE_JUGGLER, count = counts[2] },
		{ monster = CREATURE_WOOD_ELF,      count = counts[3] },
		{ monster = CREATURE_DRUID,         count = counts[4] },
		{ monster = CREATURE_UNICORN,       count = counts[5] },
		{ monster = CREATURE_TREANT,        count = counts[6] },
		{ monster = CREATURE_GREEN_DRAGON,  count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Academy
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateAcademyMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_GREMLIN,        count = counts[1] },
		{ monster = CREATURE_STONE_GARGOYLE, count = counts[2] },
		{ monster = CREATURE_IRON_GOLEM,     count = counts[3] },
		{ monster = CREATURE_MAGI,           count = counts[4] },
		{ monster = CREATURE_GENIE,          count = counts[5] },
		{ monster = CREATURE_RAKSHASA,       count = counts[6] },
		{ monster = CREATURE_GIANT,          count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Dungeon
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateDungeonMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_SCOUT,       count = counts[1] },
		{ monster = CREATURE_WITCH,       count = counts[2] },
		{ monster = CREATURE_MINOTAUR,    count = counts[3] },
		{ monster = CREATURE_RIDER,       count = counts[4] },
		{ monster = CREATURE_HYDRA,       count = counts[5] },
		{ monster = CREATURE_MATRON,      count = counts[6] },
		{ monster = CREATURE_DEEP_DRAGON, count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Fortress
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateFortressMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_DEFENDER,    count = counts[1] },
		{ monster = CREATURE_AXE_FIGHTER, count = counts[2] },
		{ monster = CREATURE_BEAR_RIDER,  count = counts[3] },
		{ monster = CREATURE_BROWLER,     count = counts[4] },
		{ monster = CREATURE_RUNE_MAGE,   count = counts[5] },
		{ monster = CREATURE_THANE,       count = counts[6] },
		{ monster = CREATURE_FIRE_DRAGON, count = counts[7] }
	}
	
	return ( table );
end;


------------------------------------------------------
-- !!!    !!!
--    , 
--      Stronghold
--
-- param counts -   7  , counts[i] -
--                  i- .   
-- return --      
--              
------------------------------------------------------
function hmm3CreateStrongholdMonstersTable( counts )
	local table;
	
	table = 
	{
		{ monster = CREATURE_GOBLIN,           count = counts[1] },
		{ monster = CREATURE_CENTAUR,          count = counts[2] },
		{ monster = CREATURE_ORC_WARRIOR,      count = counts[3] },
		{ monster = CREATURE_SHAMAN,           count = counts[4] },
		{ monster = CREATURE_ORCCHIEF_BUTCHER, count = counts[5] },
		{ monster = CREATURE_WYVERN,           count = counts[6] },
		{ monster = CREATURE_CYCLOP,           count = counts[7] }
	}
	
	return ( table );
end;



-----------------------------------------------------
-- !!!    !!!
--     player  
--   
--
-- param player    -  
-- param resources - ,     
--                       
-- param hero      -  (name) ,    
--------------------------------------------
function hmm3GivePlayerResources( player, resources, hero )
	local res = 0;
	if resources['wood'] then
		res = GetPlayerResource( player, WOOD ) + resources['wood'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, WOOD, res, hero );
		else
			SetPlayerResource( player, WOOD, res );
		end;	
	end;		
	if resources['ore'] then
		res = GetPlayerResource( player, ORE ) + resources['ore'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, ORE, res, hero );
		else
			SetPlayerResource( player, ORE, res );
		end;	
	end;		
	if resources['mercury'] then
		res = GetPlayerResource( player, MERCURY ) + resources['mercury'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, MERCURY, res, hero );
		else
			SetPlayerResource( player, MERCURY, res );
		end;	
	end;		
	if resources['crystal'] then
		res = GetPlayerResource( player, CRYSTAL ) + resources['crystal'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, CRYSTAL, res, hero );
		else
			SetPlayerResource( player, CRYSTAL, res );
		end;	
	end;		
	if resources['sulfur'] then
		res = GetPlayerResource( player, SULFUR ) + resources['sulfur'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, SULFUR, res, hero );
		else
			SetPlayerResource( player, SULFUR, res );
		end;	
	end;		
	if resources['gem'] then
		res = GetPlayerResource( player, GEM ) + resources['gem'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, GEM, res, hero );
		else
			SetPlayerResource( player, GEM, res );
		end;	
	end;		
	if resources['gold'] then
		res = GetPlayerResource( player, GOLD ) + resources['gold'];
		if res < 0 then res = 0; end;
		if hero then
			SetPlayerResource( player, GOLD, res, hero );
		else
			SetPlayerResource( player, GOLD, res );
		end;	
	end;		
end;


------------------------------------------------------
-- !!!    !!!
--   ,    .
--    ,   
--  region event   .
--
-- param hero   -  (name) 
-- return       -  (name) 
------------------------------------------------------
function hmm3GetRegionByHero( hero )
	local reg;
	for region, active in hmm3Regions do
		if active and IsObjectInRegion( hero, region ) then
			reg = region; 
		end;
	end;
	return ( reg );
end;


------------------------------------------------------
-- !!!    !!!
--     NEW_DAY_TRIGGER
------------------------------------------------------
function hmm3RunCustomNewDayHandler()
	startThread( handleCustomNewDayTrigger );
end;


------------------------------------------------------
-- !!!    !!!
--   ,    .
--    ,   
--  region event   .
--
-- param hero   -  (name) 
-- return       -  (name) 
------------------------------------------------------
function hmm3StartCombat( hero, guard, handler )
	local cnt = length( guard );
				
	if cnt == 1 then
		StartCombat( hero, nil, 1, guard[1]['monster'], guard[1]['count'], nil, handler );
	elseif cnt == 2 then
		StartCombat( hero, nil, 2,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'],
			nil, handler);
	elseif cnt == 3 then
		StartCombat( hero, nil, 3,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'], 
			guard[3]['monster'], guard[3]['count'], 
			nil, handler );
	elseif cnt == 4 then
		StartCombat( hero, nil, 4,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'],
			guard[3]['monster'], guard[3]['count'], 
			guard[4]['monster'], guard[4]['count'],
			nil, handler );
	elseif cnt == 5 then
		StartCombat( hero, nil, 5,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'],
			guard[3]['monster'], guard[3]['count'], 
			guard[4]['monster'], guard[4]['count'], 
			guard[5]['monster'], guard[5]['count'], 
			nil, handler );
	elseif cnt == 6 then
		StartCombat( hero, nil, 6,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'],
			guard[3]['monster'], guard[3]['count'], 
			guard[4]['monster'], guard[4]['count'], 
			guard[5]['monster'], guard[5]['count'], 
			guard[6]['monster'], guard[6]['count'], 
			nil, handler );
	elseif cnt == 7 then
		StartCombat( hero, nil, 7,	
			guard[1]['monster'], guard[1]['count'],
			guard[2]['monster'], guard[2]['count'],
			guard[3]['monster'], guard[3]['count'], 
			guard[4]['monster'], guard[4]['count'], 
			guard[5]['monster'], guard[5]['count'], 
			guard[6]['monster'], guard[6]['count'], 
			guard[7]['monster'], guard[7]['count'], 
			nil, handler );
	end;
	sleep(1);
end;


------------------------------------------------------
-- !!!    !!!
--       
--  players 
--
-- param players   - ,  ,   
--                     
-- param message   - ,    
------------------------------------------------------
function hmm3MessageBoxForPlayers( players, message )
	local filter;
	for idx, player in players do
		if filter then
			filter = filter + GetPlayerFilter( player );		
		else
			filter = GetPlayerFilter( player );
		end;
	end;
	MessageBoxForPlayers( filter, GetMapDataPath()..message );	
end;

------------------------------
--        HMM3 Handlers
------------------------------


-------------------------------------------------------
-- !!!    !!!
-- ""  hero    
--  reward ( . )
--
-- param hero   -  (name) 
-- param reward -  ""
-------------------------------------------------------
function hmm3HandleRewardHero( hero, reward )
	if reward then
		for type, bonus in reward do
			if type == "expo" then
				
				ChangeHeroStat( hero, STAT_EXPERIENCE, bonus );
				
			elseif type == "mana" then
				
				ChangeHeroStat( hero, STAT_MANA_POINTS, bonus );
			
			elseif type == "morale" then
			
				ChangeHeroStat( hero, STAT_MORALE, bonus );
			
			elseif type == "luck" then
				
				ChangeHeroStat( hero, STAT_LUCK, bonus );
				
			elseif type == "resources" then
			
				hmm3GivePlayerResources( GetCurrentPlayer(), bonus, hero );
					
			elseif type == "primary_skills" then
					
				if bonus['attack'] then
					ChangeHeroStat( hero, STAT_ATTACK, bonus['attack'] );
				end;
				if bonus['defence'] then
					ChangeHeroStat( hero, STAT_DEFENCE, bonus['defence'] );
				end;
				if bonus['spellpower'] then
					ChangeHeroStat( hero, STAT_SPELL_POWER, bonus['spellpower'] );
				end;
				if bonus['knowledge'] then
					ChangeHeroStat( hero, STAT_KNOWLEDGE, bonus['knowledge'] );
				end;
				
			elseif type == "secondary_skills" then
				
				for i, skill in bonus do
					GiveHeroSkill( hero, skill);
				end;
				
			elseif type == "spells" then
				
				for i, spell in bonus do
					TeachHeroSpell( hero, spell);
				end;
				
			elseif type == "artefacts" then
				
				for i, art in bonus do
					GiveArtefact( hero, art);
				end;
				
			elseif type == "creatures" then
				
				for i, stack in bonus do
					AddHeroCreatures( hero, stack['monster'], stack['count']);
				end;
				
			end;
		end;
	end;
end;


-------------------------------------------------------
-- !!!    !!!
-- ""  hero      
--    .   
--   
--
-- param hero -  (name) 
-- param win  - true,       
-------------------------------------------------------
function hmm3HandleRegionEventReward( hero, win )
	if win then
		local region = hmm3GetRegionByHero( hero );
	
		if hmm3GlobalEventParams[region]['once'] then
			hmm3Regions[region] = nil;
		end;		

		if hmm3GlobalEventParams[region]['postmsg'] then			
			hmm3MessageBoxForPlayers( hmm3GlobalEventParams[region]['players'], hmm3GlobalEventParams[region]['postmsg'] );
			sleep(1);
		end;
		
		hmm3HandleRewardHero( hero, hmm3GlobalEventParams[region]['rwd'] );
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--  region event
--
-- param hero -  (name) 
-------------------------------------------------------
function hmm3HandleRegionEvent(hero)	
	local region = hmm3GetRegionByHero( hero );
	local owner  = GetObjectOwner( hero );
	
	if hmm3IsItemInTable( hmm3GlobalEventParams[region]['players'], owner ) then	
		if not hmm3GlobalEventParams[region]['hero'] or ( hero == hmm3GlobalEventParams[region]['hero'] ) then
			
			-- before event
			
			if hmm3GlobalEventParams[region]['once'] then
				Trigger( REGION_ENTER_AND_STOP_TRIGGER, region, nil );
			end;
			
			if hmm3GlobalEventParams[region]['premsg'] then
				hmm3MessageBoxForPlayers( hmm3GlobalEventParams[region]['players'], hmm3GlobalEventParams[region]['premsg'] );
				sleep(1);
			end;
			
			-- guard
			
			if hmm3GlobalEventParams[region]['grd'] then
				hmm3StartCombat( hero, hmm3GlobalEventParams[region]['grd'], "hmm3HandleRegionEventReward" );
			else
				-- rewards		
				hmm3HandleRegionEventReward( hero, 1 );
			end;
		end;
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--  monster event
--
-- param hero    -  (name) 
-- param monster -  (name) 
-------------------------------------------------------
function hmm3HandleMonsterEvent ( hero, monster )
	Trigger( OBJECT_TOUCH_TRIGGER, monster, nil );
	SetObjectEnabled( monster, 1 );
	sleep(1);
	
	if hmm3GlobalEventParams[monster]['premsg'] then
		hmm3MessageBoxForPlayers( { GetCurrentPlayer() }, hmm3GlobalEventParams[monster]['premsg'] );
		sleep(1);
	end;

	MakeHeroInteractWithObject( hero, monster );
	sleep(1);
	
	hmm3HandleRewardHero( hero, hmm3GlobalEventParams[monster]['rwd'] );
end;


-------------------------------------------------------
-- !!!    !!!
--  treasure event,  ,   
--  ,       
-- 
-------------------------------------------------------
function hmm3HandleTreasureEventReward( hero, win )
	if win then
		local treasure = hmm3TreasureEventCurrents['name'];

		Trigger( OBJECT_TOUCH_TRIGGER, treasure, nil );
		sleep(1);

		SetObjectEnabled( treasure, 1 );
		sleep(1);

		MakeHeroInteractWithObject( hero, treasure );
		sleep(1);
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--  treasure event,  ,   
--       
-------------------------------------------------------
function hmm3HandleTreasureEventYes()
	local event = hmm3GlobalEventParams[ hmm3TreasureEventCurrents['name'] ];
	
	hmm3StartCombat( hmm3TreasureEventCurrents['hero'], event['guard'], "hmm3HandleTreasureEventReward" );
end;


-------------------------------------------------------
-- !!!    !!!
--  treasure event
--
-- param hero     -  (name) 
-- param treasure -  (name) 
-------------------------------------------------------
function hmm3HandleTreasureEvent ( hero, treasure )
	if not hmm3GlobalEventParams[treasure]['hero'] or (hero == hmm3GlobalEventParams[treasure]['hero']) then			
		if hmm3GlobalEventParams[treasure]['premsg'] and hmm3GlobalEventParams[treasure]['guard'] then

			hmm3TreasureEventCurrents = {hero = hero, name = treasure};
			QuestionBoxForPlayers( GetPlayerFilter( GetCurrentPlayer() ), GetMapDataPath()..hmm3GlobalEventParams[treasure]['premsg'], "hmm3HandleTreasureEventYes" );

		else
			Trigger( OBJECT_TOUCH_TRIGGER, treasure, nil );
			sleep(1);

			SetObjectEnabled( treasure, 1 );
			sleep(1);

			MakeHeroInteractWithObject( hero, treasure );
			sleep(1);
		end;
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--  map timer-event
--
-- param event -    
-------------------------------------------------------
function hmm3HandleMapTimerEvent( event )
	local player = GetCurrentPlayer();
	
	if hmm3IsItemInTable( event['players'], player ) then	
		if event['msg'] then
			hmm3MessageBoxForPlayers( event['players'], event['msg']);
			sleep(1);
		end;
		
		if event['reward'] then
			hmm3GivePlayerResources( player, event['reward']['resources'], nil);
		end;
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--  town timer-event
--
-- param event -    
-------------------------------------------------------
function hmm3HandleTownTimerEvent( event )
	local player = GetCurrentPlayer();
	
	if hmm3IsItemInTable( event['players'], player ) then	
		if event['msg'] then
			hmm3MessageBoxForPlayers( event['players'], event['msg'] );
			sleep(1);
		end;
		
		if event['reward'] then
			for type, bonus in event['reward'] do
				
				if type == "resources" then
					
					hmm3GivePlayerResources( player, bonus, nil);
					
				elseif type == "monsters" then
				
					local tmp;
					local monsters;

					if event['town_type'] == TOWN_HEAVEN then
						monsters = hmm3CreateHeavenMonstersTable( bonus );
					elseif event['town_type'] == TOWN_INFERNO then
						monsters = hmm3CreateInfernoMonstersTable( bonus );
					elseif event['town_type'] == TOWN_NECROMANCY then
						monsters = hmm3CreateNecropolisMonstersTable( bonus );
					elseif event['town_type'] == TOWN_PRESERVE then
						monsters = hmm3CreatePreserveMonstersTable( bonus );
					elseif event['town_type'] == TOWN_ACADEMY then
						monsters = hmm3CreateAcademyMonstersTable( bonus );
					elseif event['town_type'] == TOWN_DUNGEON then
						monsters = hmm3CreateDungeonMonstersTable( bonus );
					elseif event['town_type'] == TOWN_FORTRESS then
						monsters = hmm3CreateFortressMonstersTable( bonus );
					elseif  event['town_type'] == TOWN_STRONGHOLD then
						monsters = hmm3CreateStrongholdMonstersTable( bonus );
					end;
					for id, monster in monsters do
						tmp = GetObjectDwellingCreatures( event['town'], monster['monster'] );
						if tmp >= 0 then
							SetObjectDwellingCreatures( event['town'], monster['monster'], monster['count'] + tmp );
						end;
					end;	
					
				elseif type == "buildings" then
				
					for id, building in bonus do
						local level      = GetTownBuildingLevel( event['town'], building['type'] );
						local maxlevel   = GetTownBuildingMaxLevel( event['town'], building['type'] );
						local limitlevel = GetTownBuildingLimitLevel( event['town'], building['type'] );
						
						local need = building['level'];
						if level < need then
							if need > maxlevel then
								need = maxlevel;
							end;
							
							if need > limitlevel then
								SetTownBuildingLimitLevel( event['town'], building['type'], need );
							end;
							
							for i = level, need - 1, 1 do
								UpgradeTownBuilding( event['town'], building['type'] );
							end;
						end;
					end;
					
				end;
				
			end;
		end;
	end;
end;


-------------------------------------------------------
-- !!!    !!!
--     timer-events
--
-- param event -    
-------------------------------------------------------
function hmm3HandleTimerEvent()
	local day = GetDate( DAY );
	for name, event in hmm3Timers do
		if event['day'] == day then			
			if event['type'] == 1 then				
				hmm3HandleMapTimerEvent( event );
				if event['reply'] then
					hmm3Timers[name]['day'] = hmm3Timers[name]['day'] + event['reply'];
				end;
			end;			
		end;
	end;
	for name, event in hmm3Timers do
		if event['day'] == day then			
			if event['type'] == 2 then
				hmm3HandleTownTimerEvent( event );
				if event['reply'] then
					hmm3Timers[name]['day'] = hmm3Timers[name]['day'] + event['reply'];
				end;
			end;			
		end;
	end;

	-- run user defined handlers

	hmm3RunCustomNewDayHandler();
end;


------------------------------
--            HMM3 API
------------------------------


-------------------------------------------------------
--  region event.   - . 
--
-- param players      -  ,   
--                      
-- param region       -  (name) 
-- param hero         -  (name) ,   
--                       (nil   ). 
-- param pre_message  -    ,   
--                        
-- param post_message -    ,   
--                        
-- param guard        -    
-- param reward       -   
-- param once         - true,     
-------------------------------------------------------
function hmm3CreateRegionEvent( players, region, hero, pre_message, post_message, guard, reward, once)
	Trigger( REGION_ENTER_AND_STOP_TRIGGER, region, 'hmm3HandleRegionEvent' );
	hmm3Regions[region] = 1;
	hmm3GlobalEventParams[region] = 
	{
		players = players,
		premsg  = pre_message,	
		postmsg = post_message,
		grd     = guard,
		rwd     = reward,
		once    = once,
		hero    = hero
	};
end;


-------------------------------------------------------
--  monster event.   - . 
--
-- param monster      -  (name) 
-- param hero         -  (name) ,   
--                       (nil   ). 
-- param pre_message  -    ,   
--                        
-- param reward       -   
-------------------------------------------------------
function hmm3CreateMonsterEvent( monster, hero, pre_message, reward )
	SetObjectEnabled( monster, nil );
	Trigger(OBJECT_TOUCH_TRIGGER, monster, 'hmm3HandleMonsterEvent');
	hmm3GlobalEventParams[monster] = 
	{
		players = players,
		premsg  = pre_message,	
		rwd     = reward,
		hero    = hero
	};
end;


-------------------------------------------------------
--  treasure event.   - . 
--
-- param treasure     -  (name) 
-- param hero         -  (name) ,   
--                       (nil   ). 
-- param pre_message  -    ,   
--                        
-- param guard        -    
-------------------------------------------------------
function hmm3CreateTreasureEvent ( treasure, hero, pre_message, guard )
	SetObjectEnabled( treasure, nil );
	Trigger(OBJECT_TOUCH_TRIGGER, treasure, 'hmm3HandleTreasureEvent');
	hmm3GlobalEventParams[treasure] = 
	{
		premsg  = pre_message,	
		guard   = guard,
		hero    = hero
	};
end;


-------------------------------------------------------
--  map timer-event.   - . 
--
-- param players      -  ,   
--                      
-- param name         -   
-- param day          -    
-- param reply        -   (nil,  ) 
-- param message      -    ,   
--                          
-- param reward       -   
-------------------------------------------------------
function hmm3CreateMapEvent( players, name, day, reply, message, reward )
	if not hmm3TimerHandlerUp then
		Trigger( NEW_DAY_TRIGGER, "hmm3HandleTimerEvent" );
		hmm3TimerHandlerUp = 1;
	end;

	if reward then
		for i, rwd in reward do
			if i ~= "resources" then
				reward[i] = nil;
			end;
		end;
	end;
	
	hmm3Timers[name] = 
	{
		type    = 1, --  MAP event
		players = players,
		day     = day,	
		reply   = reply,
		msg     = message,
		reward  = reward
	};	
	
	if day == 1 then
		hmm3HandleMapTimerEvent( hmm3Timers[name] );
		if reply then
			hmm3Timers[name]['day'] = day + reply;
		end;
	end;	
end;


-------------------------------------------------------
--  map timer-event.   - . 
--
-- param players      -  ,   
--                      
-- param name         -  (  )  
-- param town         -  (name) 
-- param day          -    
-- param reply        -   (nil,  ) 
-- param message      -    ,   
--                          
-- param reward       -   
-- param town         -   
-------------------------------------------------------
function hmm3CreateTownEvent( players, name, town, day, reply, message, reward, town_type )
	if not hmm3TimerHandlerUp then
		Trigger( NEW_DAY_TRIGGER, "hmm3HandleTimerEvent" );
		hmm3TimerHandlerUp = 1;
	end;

	if reward then
		for i, rwd in reward do
			if i ~= "resources" and i ~= "buildings" and i ~= "monsters" then
				reward[i] = nil;
			end;
		end;
	end;

	name = town..name;
	hmm3Timers[name] = 
	{
		type      = 2, --  TOWN event
		players   = players,
		town      = town,
		day       = day,	
		reply     = reply,
		msg       = message,
		reward    = reward,
		town_type = town_type
	};	
	
	if day == 1 then
		hmm3HandleTownTimerEvent( hmm3Timers[name] );
		if reply then
			hmm3Timers[name]['day'] = day + reply;
		end;
	end;
end;